#include <iostream>
#include <fstream>
#include <string>
using namespace std;

struct OSOBA {				// musi byt pred deklaracemi funkci, protoze je
	string jmeno;			//  pouzivana v jejich parametrech
	int identifikator;
};

// deklarace funkci, jejich definice jsou za main()					
void nactiOsobu (OSOBA &o);		// vsimnete si: parametr volany odkazem, reference
void zapisOsobuDoSouboru (fstream &f, OSOBA o);   // prvni odkazem, druhy hodnotou

int main() {
	fstream soubor;
	const int delka = 4;
	OSOBA osoby[delka];

	soubor.open("soubor.txt", ios::out | ios::trunc);
	if (!soubor.is_open()) {
		cerr << "Soubor se neotevrel\n";
		return 1;
	}
	for (int i = 0; i < delka; i++) {
		nactiOsobu (osoby[i]);
		zapisOsobuDoSouboru(soubor, osoby[i]);
	}
	soubor.close();
}

void nactiOsobu (OSOBA &o) {
	cout << "Zadej jmeno: ";
	cin >> o.jmeno;
	cout << "Zadej identifikator: ";
	cin >> o.identifikator;
}

void zapisOsobuDoSouboru (fstream &f, OSOBA o) {
	if (f.is_open())
		f << o.jmeno << '\t' << o.identifikator << endl;
	else
		cerr << "Soubor neni otevren, zapis nebyl proveden\n";
}
