(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     28481,        789]
NotebookOptionsPosition[     16258,        549]
NotebookOutlinePosition[     21539,        672]
CellTagsIndexPosition[     21496,        669]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["ModelPaclet`", "Affiliation",ExpressionUUID->"4811c644-6998-4c62-aa30-611fb336dd4d"],

Cell[CellGroupData[{

Cell["sayHello", "Title",ExpressionUUID->"eb403ecb-ed4d-40ce-b51f-21ff1c479205"],

Cell["sayHello[] returns string \"Hello World!\".", "Subtitle",ExpressionUUID->"deb40e7c-e6b4-4c53-aea4-0895f9a28e37"],

Cell[TextData[{
 "sayHello[",
 StyleBox["str", "TI"],
 "] returns string ",
 StyleBox["str", "TI"],
 " (shortened if too long)."
}], "Subtitle",ExpressionUUID->"0fe6ea73-0865-4291-9e9c-5c07fc7fdaef"],

Cell[TextData[{
 "sayHello[",
 StyleBox["str", "TI"],
 ", ",
 StyleBox["form", "TI"],
 "] applies formatting function ",
 StyleBox["form", "TI"],
 " to the string returned."
}], "Subtitle",ExpressionUUID->"aa3e9479-cd1b-4260-86a8-4e3fc9b9e194"],

Cell[CellGroupData[{

Cell["Details", "Section",ExpressionUUID->"4115d32b-2208-4f95-8985-767fc1182068"],

Cell[CellGroupData[{

Cell[TextData[{
 "Typical formatting function form can be a symbol (like ",
 ButtonBox["ToUpperCase",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ToUpperCase"],
 "), a ",
 ButtonBox["Function",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Function"],
 " (like ",
 ButtonBox["Style",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Style"],
 "[#, ",
 ButtonBox["Red",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Red"],
 "]&), and a ",
 ButtonBox["Composition",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Composition"],
 " (like (",
 ButtonBox["Style",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Style"],
 "[#, ",
 ButtonBox["Red",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Red"],
 "]& ",
 ButtonBox["@*",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Composition"],
 " ",
 ButtonBox["ToUpperCase",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ToUpperCase"],
 ") or ",
 ButtonBox["RightComposition",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/RightComposition"],
 " (like ",
 ButtonBox["ToUpperCase",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ToUpperCase"],
 " ",
 ButtonBox["/*",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/RightComposition"],
 " (",
 ButtonBox["Style",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Style"],
 "[#, ",
 ButtonBox["Red",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Red"],
 "]&))."
}], "Item",ExpressionUUID->"880fda2d-419c-4bde-b3f1-d4411c6b5ab0"],

Cell[TextData[{
 "If using ",
 ButtonBox["Composition",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Composition"],
 " and ",
 ButtonBox["RightComposition",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/RightComposition"],
 ", the results may (but need not) depend on the ordering of composed \
functions."
}], "Item",ExpressionUUID->"5eedd9aa-c1e6-4d7c-9fb1-569bc4cff424"],

Cell[TextData[{
 "For any other formatting function, error message will be issued and ",
 ButtonBox["$Failed",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/$Failed"],
 " will be returned."
}], "Item",ExpressionUUID->"155a5025-f61d-4c41-a6af-18bd3b41450c"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Background & Context", "Section",ExpressionUUID->"ad852ca8-80ba-4f05-8b13-83b19437b715"],

Cell[CellGroupData[{

Cell["\<\
ModelPaclet is a model of a simple toy paclet for instructional purposes.  \
The sayHello symbol represents just a more or less meaningless function to be \
used as an demonstration.\
\>", "Item",ExpressionUUID->"e8cc0e04-47ba-480e-89b1-49777f82efa3"],

Cell["The ModelPaclet symbol is used as a general error handler.", "Item",ExpressionUUID->"3b88105c-37e6-4f14-ad03-f55fef00175a"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Section",ExpressionUUID->"d3d292b2-25c7-4cd5-90a2-1b798112848e"],

Cell[CellGroupData[{

Cell["Basic Examples", "Subsection",ExpressionUUID->"73fb9c96-bbd5-4621-b5d2-03ca80ba2af6"],

Cell["Load the paclet:", "Text",ExpressionUUID->"8f68af07-5ada-43df-9a18-b487faea5d47"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<ModelPaclet`\>\"", "]"}]], "Input",
 CellLabel->
  "In[119]:=",ExpressionUUID->"c10f474e-93e8-4e46-a553-11e0e849dbc7"],

Cell["Let us display the well-known message:", "Text",ExpressionUUID->"7f04c3bb-fdf6-4a90-a6be-7f3f52e496c7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sayHello", "[", "]"}]], "Input",
 CellLabel->
  "In[120]:=",ExpressionUUID->"e02b413f-01ab-4219-bb30-4a3e7d705adb"],

Cell[BoxData["\<\"Hello World!\"\>"], "Output",
 CellLabel->
  "Out[120]=",ExpressionUUID->"66e988ee-f46a-4236-aedb-7e12e2ce2022"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Scope", "Subsection",ExpressionUUID->"cc4d6c37-4ef9-4364-9445-57a36799e818"],

Cell["Colorize the message:", "Text",ExpressionUUID->"218b0942-d3b5-41a8-9a2e-8824836de59b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sayHello", "[", 
  RowBox[{
   RowBox[{"Style", "[", 
    RowBox[{"#", ",", "Red"}], "]"}], "&"}], "]"}]], "Input",
 CellLabel->
  "In[121]:=",ExpressionUUID->"a69eccc6-e72d-4728-9559-757e63a64c29"],

Cell[BoxData[
 StyleBox["\<\"Hello World!\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0, 0],
  FrontFaceColor->RGBColor[1, 0, 0],
  BackFaceColor->RGBColor[1, 0, 0],
  GraphicsColor->RGBColor[1, 0, 0],
  FontColor->RGBColor[1, 0, 0]]], "Output",
 CellLabel->
  "Out[121]=",ExpressionUUID->"e8503c2d-75a2-41ff-a5a3-c52e21c51f0c"]
}, Open  ]],

Cell["Display text in uppercase:", "Text",ExpressionUUID->"ced77b85-1bc5-4796-a17c-f2ca3ca421cd"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sayHello", "[", "ToUpperCase", "]"}]], "Input",
 CellLabel->
  "In[122]:=",ExpressionUUID->"afdf01d1-448d-4a6e-a149-4db2388cca6c"],

Cell[BoxData["\<\"HELLO WORLD!\"\>"], "Output",
 CellLabel->
  "Out[122]=",ExpressionUUID->"470f39a2-9055-4f20-be38-3983fed34ed2"]
}, Open  ]],

Cell[TextData[{
 "Combine formatting functions using ",
 ButtonBox["Composition",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Composition"],
 " (",
 ButtonBox["@*",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Composition"],
 ") to get red uppercase message:"
}], "Text",ExpressionUUID->"29ba6cd4-49c8-4170-ab29-04a939f11bc6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sayHello", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Style", "[", 
      RowBox[{"#", ",", "Red"}], "]"}], "&"}], ")"}], "@*", "ToUpperCase"}], 
  "]"}]], "Input",
 CellLabel->
  "In[123]:=",ExpressionUUID->"bce2cfc3-c7db-4efa-8079-5211421b54f3"],

Cell[BoxData[
 StyleBox["\<\"HELLO WORLD!\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0, 0],
  FrontFaceColor->RGBColor[1, 0, 0],
  BackFaceColor->RGBColor[1, 0, 0],
  GraphicsColor->RGBColor[1, 0, 0],
  FontColor->RGBColor[1, 0, 0]]], "Output",
 CellLabel->
  "Out[123]=",ExpressionUUID->"40858f1a-a07f-46e1-9223-5fd2dd0ed85a"]
}, Open  ]],

Cell[TextData[{
 "Combine  formatting functions using ",
 ButtonBox["RightComposition",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/RightComposition"],
 " (",
 ButtonBox["/*",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/RightComposition"],
 ") to get big uppercase message:"
}], "Text",ExpressionUUID->"7787b66b-9a1b-43ad-805b-b48f7d3626bd"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sayHello", "[", 
  RowBox[{"ToUpperCase", "/*", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Style", "[", 
      RowBox[{"#", ",", "Large"}], "]"}], "&"}], ")"}]}], "]"}]], "Input",
 CellLabel->
  "In[124]:=",ExpressionUUID->"4c26a6e0-16f5-4971-9ec8-11319a04db5e"],

Cell[BoxData[
 StyleBox["\<\"HELLO WORLD!\"\>",
  StripOnInput->False,
  FontSize->Large]], "Output",
 CellLabel->
  "Out[124]=",ExpressionUUID->"e7254a76-528e-42a9-a586-8f6023396169"]
}, Open  ]],

Cell["Use another text (e.g., in Czech):", "Text",ExpressionUUID->"ac96bed3-2e93-4716-90ce-eb53a17dd490"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sayHello", "[", 
  "\"\<Zdrav\[IAcute]m \[UAcute]\[CHacek]astn\[IAcute]ky Setk\[AAcute]n\
\[IAcute] u\[ZHacek]ivatel\[URing] syst\[EAcute]mu Mathematica '21!\>\"", 
  "]"}]], "Input",
 CellLabel->
  "In[125]:=",ExpressionUUID->"666d1196-87bb-44a5-9824-513be8ee64aa"],

Cell[BoxData["\<\"Zdrav\[IAcute]m \[UAcute]\[CHacek]astn\[IAcute]ky Setk\
\[AAcute]n\[IAcute] u\[ZHacek]ivatel\[URing] syst\[EAcute]mu Mathematica '21!\
\"\>"], "Output",
 CellLabel->
  "Out[125]=",ExpressionUUID->"414b949e-4a82-4298-85ee-5468461faaa0"]
}, Open  ]],

Cell["The text will be shortened if exceedingly long:", "Text",ExpressionUUID->"0a3db1ac-9742-4de6-9e9c-4082c3cd36aa"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sayHello", "[", 
  "\"\<Zdrav\[IAcute]m \[UAcute]\[CHacek]astn\[IAcute]ky Setk\[AAcute]n\
\[IAcute] u\[ZHacek]ivatel\[URing] syst\[EAcute]mu Mathematica '21 konan\
\[EAcute]ho v \[UAcute]ter\[YAcute] 9. \[UAcute]nora 2021!\>\"", 
  "]"}]], "Input",
 CellLabel->
  "In[126]:=",ExpressionUUID->"958ceeff-a0be-452c-96aa-9a6b9856ef6f"],

Cell[BoxData["\<\"Zdrav\[IAcute]m \[UAcute]\[CHacek]astn\[IAcute]ky Setk\
\[AAcute]n<<19>> Mathematica '21 konan\[EAcute]ho v \[UAcute]ter\[YAcute] 9. \
\[UAcute]nora 2021!\"\>"], "Output",
 CellLabel->
  "Out[126]=",ExpressionUUID->"f8fa363c-a007-4789-820b-638624bf55c4"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Possible Issues", "Subsection",ExpressionUUID->"23b553f1-b112-483c-8045-2914b541df74"],

Cell[TextData[{
 "Error message is printed if an improper argument is supplied, and ",
 ButtonBox["$Failed",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/$Failed"],
 " is returned:"
}], "Text",ExpressionUUID->"1bc77fe8-34fc-44b2-a602-01fa2e30a327"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sayHello", "[", "1", "]"}]], "Input",
 CellLabel->
  "In[127]:=",ExpressionUUID->"7e84b30d-6099-4541-932b-73b59234837c"],

Cell[BoxData[
 TemplateBox[{
  "ModelPaclet", "badarg", 
   "\"\\!\\(\\*RowBox[{\\\"\\\\\\\"sayHello\\\\\\\"\\\"}]\\)[\\!\\(\\*\
TemplateBox[List[\\\",\\\", \\\"\\\\\\\",\\\\\\\"\\\", \\\"1\\\"], \
\\\"RowWithSeparators\\\"]\\)] does not match the rule base.\"", 2, 127, 11, 
   23277114848512901781, "Local", "ModelPaclet`ModelPaclet"},
  "MessageTemplate2"]], "Message", "MSG",
 CellLabel->
  "During evaluation of \
In[127]:=",ExpressionUUID->"00a20b07-940b-448b-9b5b-65b94ca01143"],

Cell[BoxData["$Failed"], "Output",
 CellLabel->
  "Out[127]=",ExpressionUUID->"5fb7ed8a-df96-4c25-95eb-7dd1169d3de2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sayHello", "[", "1.", "]"}]], "Input",
 CellLabel->
  "In[128]:=",ExpressionUUID->"879ff9b5-7127-4af1-add4-3a2413d42bde"],

Cell[BoxData[
 TemplateBox[{
  "ModelPaclet", "badarg", 
   "\"\\!\\(\\*RowBox[{\\\"\\\\\\\"sayHello\\\\\\\"\\\"}]\\)[\\!\\(\\*\
TemplateBox[List[\\\",\\\", \\\"\\\\\\\",\\\\\\\"\\\", \\\"1.`\\\"], \
\\\"RowWithSeparators\\\"]\\)] does not match the rule base.\"", 2, 128, 12, 
   23277114848512901781, "Local", "ModelPaclet`ModelPaclet"},
  "MessageTemplate2"]], "Message", "MSG",
 CellLabel->
  "During evaluation of \
In[128]:=",ExpressionUUID->"d9ca2d63-7d9f-48fa-8f26-e2f306f16b63"],

Cell[BoxData["$Failed"], "Output",
 CellLabel->
  "Out[128]=",ExpressionUUID->"cad5a5df-d0c0-4c0b-9de8-fed7902bdd46"]
}, Open  ]],

Cell[TextData[{
 "Combining using ",
 ButtonBox["Composition",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Composition"],
 " (",
 ButtonBox["@*",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Composition"],
 ") or ",
 ButtonBox["RightComposition",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/RightComposition"],
 " (",
 ButtonBox["/*",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/RightComposition"],
 ") need not be commutative:"
}], "Text",ExpressionUUID->"05848441-558f-40cd-8317-935b228f9cd4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sayHello", "[", 
  RowBox[{"ToUpperCase", "@*", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Style", "[", 
      RowBox[{"#", ",", "Red"}], "]"}], "&"}], ")"}]}], "]"}]], "Input",
 CellLabel->
  "In[129]:=",ExpressionUUID->"49879676-c97b-4b87-bea8-9fa73f5fab83"],

Cell[BoxData[
 RowBox[{"ToUpperCase", "[", 
  StyleBox["\<\"Hello World!\"\>",
   StripOnInput->False,
   LineColor->RGBColor[1, 0, 0],
   FrontFaceColor->RGBColor[1, 0, 0],
   BackFaceColor->RGBColor[1, 0, 0],
   GraphicsColor->RGBColor[1, 0, 0],
   FontColor->RGBColor[1, 0, 0]], "]"}]], "Output",
 CellLabel->
  "Out[129]=",ExpressionUUID->"fc4ef51a-b51b-4d11-9e00-5fc3ff81eb0d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sayHello", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Style", "[", 
      RowBox[{"#", ",", "Red"}], "]"}], "&"}], ")"}], "/*", "ToUpperCase"}], 
  "]"}]], "Input",
 CellLabel->
  "In[130]:=",ExpressionUUID->"2eab8010-5b33-4e3e-9af7-28a698b9c7f8"],

Cell[BoxData[
 RowBox[{"ToUpperCase", "[", 
  StyleBox["\<\"Hello World!\"\>",
   StripOnInput->False,
   LineColor->RGBColor[1, 0, 0],
   FrontFaceColor->RGBColor[1, 0, 0],
   BackFaceColor->RGBColor[1, 0, 0],
   GraphicsColor->RGBColor[1, 0, 0],
   FontColor->RGBColor[1, 0, 0]], "]"}]], "Output",
 CellLabel->
  "Out[130]=",ExpressionUUID->"dd0273c5-62f9-48a5-8e53-5d4bb6be5eb3"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Neat Examples", "Subsection",ExpressionUUID->"158b5bba-3784-4745-a7fd-3e0e96ad7008"],

Cell["Shortened long text in a big slanted Helvetica font:", "Text",ExpressionUUID->"f58756c8-cc45-4cbc-9b6c-8b486e6517eb"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sayHello", "[", 
  RowBox[{
  "\"\<Zdrav\[IAcute]m \[UAcute]\[CHacek]astn\[IAcute]ky Setk\[AAcute]n\
\[IAcute] u\[ZHacek]ivatel\[URing] syst\[EAcute]mu Mathematica '21 konan\
\[EAcute]ho v \[UAcute]ter\[YAcute] 9. \[UAcute]nora 2021!\>\"", ",", 
   RowBox[{
    RowBox[{"Style", "[", 
     RowBox[{"#", ",", 
      RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
      RowBox[{"FontSize", "\[Rule]", "24"}], ",", " ", 
      RowBox[{"FontSlant", "\[Rule]", "Italic"}], ",", 
      RowBox[{"FontColor", "\[Rule]", "Red"}]}], "]"}], "&"}]}], 
  "]"}]], "Input",
 CellLabel->
  "In[131]:=",ExpressionUUID->"cfad8c3f-afdc-4a11-973f-110d6120fefc"],

Cell[BoxData[
 StyleBox["\<\"Zdrav\[IAcute]m \[UAcute]\[CHacek]astn\[IAcute]ky \
Setk\[AAcute]n<<19>> Mathematica '21 konan\[EAcute]ho v \[UAcute]ter\[YAcute] \
9. \[UAcute]nora 2021!\"\>",
  StripOnInput->False,
  FontFamily->"Helvetica",
  FontSize->24,
  FontSlant->Italic,
  FontColor->RGBColor[1, 0, 0]]], "Output",
 CellLabel->
  "Out[131]=",ExpressionUUID->"a90d3e40-f2a1-4b85-8151-7eba40098800"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["See Also", "Chapter",ExpressionUUID->"0d542412-eca2-43f5-a66f-94b8d94546ca"],

Cell["\[LongDash]", "Text",ExpressionUUID->"ebec6a58-adb0-419c-84af-7d8037665496"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Tutorials", "Chapter",ExpressionUUID->"17494725-bea5-40b1-b646-196e8ec719cc"],

Cell["\[LongDash]", "Text",ExpressionUUID->"ba8d13b7-4aa9-4192-a804-a0823961829c"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Related Guides", "Chapter",ExpressionUUID->"369e3b80-4eed-49ec-9d21-5569a9ad053b"],

Cell[TextData[ButtonBox["ModelPaclet",
 BaseStyle->"Hyperlink",
 ButtonData->{
   FrontEnd`FileName[{
     ParentDirectory[
      ParentDirectory[]], "Guides"}, "ModelPaclet.nb", CharacterEncoding -> 
    "UTF-8"], None}]], "Text",ExpressionUUID->"5ce41575-ddeb-4855-8a4e-\
c87a4a7b242d"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Related Workflows", "Chapter",ExpressionUUID->"5d4cf6d5-f2db-47a8-a854-ba3cfbd23f16"],

Cell["\[LongDash]", "Text",ExpressionUUID->"0955e270-9660-4119-be78-4dc87f62a5c1"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Related Links", "Chapter",ExpressionUUID->"276bdc99-eff6-4733-8c7c-7c40a3592e80"],

Cell["\[LongDash]", "Item",ExpressionUUID->"479f8fb9-40f3-475f-a471-55e2a41b7d2b"],

Cell["Introduced in Version 1.0, last updated in Version 1.0", "Abstract",ExpressionUUID->"e19bb8a6-550e-44a6-8131-d71f1c21a151"]
}, Open  ]]
}, Open  ]]
},
Saveable->False,
WindowSize->{1144, 1022},
WindowMargins->{{Automatic, 179}, {Automatic, 0}},
ShowCellBracket->True,
TrackCellChangeTimes->False,
FrontEndVersion->"12.1 for Microsoft Windows (64-bit) (June 9, 2020)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[StyleDefinitions -> "Default.nb"]], 
   Cell[
    StyleData["Title"], CellFrame -> {{0, 0}, {2, 0}}, ShowCellBracket -> 
    False, CellMargins -> {{30, 0}, {0, 18}}, 
    CellFrameMargins -> {{30, 30}, {24, 18}}, CellFrameColor -> 
    GrayLevel[0.878431], FontSize -> 37, FontWeight -> "DemiBold", 
    FontTracking -> "Plain", FontColor -> GrayLevel[0.2]], 
   Cell[
    StyleData["Subtitle"], CellFrame -> {{0, 0}, {2, 2}}, ShowCellBracket -> 
    False, CellMargins -> {{0, 0}, {0, -2}}, 
    CellFrameMargins -> {{30, 20}, {18, 18}}, CellFrameColor -> 
    GrayLevel[0.878431], ParagraphIndent -> -36, FontSize -> 15, FontColor -> 
    GrayLevel[0], Background -> RGBColor[0.956863, 1, 0.988235]], 
   Cell[
    StyleData["Affiliation"], CellFrame -> {{0, 0}, {2, 0}}, ShowCellBracket -> 
    False, CellMargins -> {{0, 0}, {0, 0}}, 
    CellFrameMargins -> {{30, 30}, {12, 7}}, CellFrameColor -> 
    GrayLevel[0.878431], FontSize -> 19, FontWeight -> "Plain", FontColor -> 
    RGBColor[1, 0.882353, 0.768627], Background -> 
    RGBColor[0.376471, 0.188235, 0]], 
   Cell[
    StyleData["Chapter"], CellFrame -> {{0, 0}, {0, 2}}, ShowCellBracket -> 
    False, CellMargins -> {{30, 0}, {8, 12}}, 
    CellFrameMargins -> {{8, 8}, {8, 8}}, CellFrameColor -> 
    GrayLevel[0.878431], LineSpacing -> {1, 3}, FontSize -> 18, FontWeight -> 
    "DemiBold", FontColor -> GrayLevel[0.533333]], 
   Cell[
    StyleData["Section"], CellFrame -> False, ShowCellBracket -> False, 
    CellMargins -> {{30, Inherited}, {8, 18}}, CellFrameMargins -> 0, 
    FontSize -> 21, FontWeight -> "DemiBold", FontColor -> 
    RGBColor[0.729412, 0.27451, 0.0784314]], 
   Cell[
    StyleData["Subsection"], ShowCellBracket -> False, 
    CellMargins -> {{66, 3.}, {8., 10.}}, FontSize -> 18, FontWeight -> 
    "DemiBold", FontColor -> RGBColor[0.729412, 0.27451, 0.0784314]], 
   Cell[
    StyleData["Subsubsection"], ShowCellBracket -> False, 
    CellMargins -> {{66, Inherited}, {8, 8}}, FontSize -> 15, FontWeight -> 
    "DemiBold", FontColor -> RGBColor[0.729412, 0.27451, 0.0784314]], 
   Cell[
    StyleData["Text"], ShowCellBracket -> False, 
    CellMargins -> {{66, 20}, {4, 8}}], 
   Cell[
    StyleData["Item"], CellDingbat -> 
    StyleBox["\[FilledSmallSquare]", Alignment -> Baseline, 
      GrayLevel[0.6]], ShowCellBracket -> False, 
    CellMargins -> {{79, 20}, {4, 8}}], 
   Cell[
    StyleData["ItemNumbered"], CellDingbat -> Cell[
      TextData[{
        CounterBox["ItemNumbered"], "."}], FontWeight -> "DemiBold", 
      FontColor -> GrayLevel[0.4]], ShowCellBracket -> False, 
    CellMargins -> {{79, 20}, {4, 8}}], 
   Cell[
    StyleData["ItemParagraph"], ShowCellBracket -> False, 
    CellMargins -> {{79, 20}, {4, 1}}, FontColor -> GrayLevel[0]], 
   Cell[
    StyleData["Subitem"], CellDingbat -> 
    StyleBox["\[FilledUpTriangle]", Alignment -> Baseline, 
      GrayLevel[0.6]], ShowCellBracket -> False, 
    CellMargins -> {{106, 20}, {4, 4}}], 
   Cell[
    StyleData["SubitemNumbered"], CellDingbat -> Cell[
      TextData[{
        CounterBox["ItemNumbered"], ".", 
        CounterBox["SubitemNumbered"], "."}], FontWeight -> "DemiBold", 
      FontColor -> GrayLevel[0.4]], ShowCellBracket -> False, 
    CellMargins -> {{106, 20}, {4, 4}}], 
   Cell[
    StyleData["SubitemParagraph"], ShowCellBracket -> False, 
    CellMargins -> {{106, 20}, {4, 1}}, FontColor -> GrayLevel[0]], 
   Cell[
    StyleData["Subsubitem"], CellDingbat -> 
    StyleBox["\[FilledSmallCircle]", Alignment -> Baseline, 
      GrayLevel[0.6]], ShowCellBracket -> False, 
    CellMargins -> {{144, 20}, {4, 4}}], 
   Cell[
    StyleData["SubsubitemNumbered"], CellDingbat -> Cell[
      TextData[{
        CounterBox["ItemNumbered"], ".", 
        CounterBox["SubitemNumbered"], ".", 
        CounterBox["SubsubitemNumbered"], "."}], FontWeight -> "DemiBold", 
      FontColor -> GrayLevel[0.4]], ShowCellBracket -> False, 
    CellMargins -> {{144, 20}, {4, 4}}], 
   Cell[
    StyleData["SubsubitemParagraph"], ShowCellBracket -> False, 
    CellMargins -> {{144, 20}, {4, 1}}, FontColor -> GrayLevel[0]], 
   Cell[
    StyleData["Program"], CellMargins -> {{66, 20}, {8, 8}}, CellFrameColor -> 
    GrayLevel[0.7]], 
   Cell[
    StyleData["DisplayFormula"], 
    CellMargins -> {{66, 20}, {Inherited, Inherited}}], 
   Cell[
    StyleData["DisplayFormulaNumbered"], 
    CellMargins -> {{66, 20}, {Inherited, Inherited}}], 
   Cell[
    StyleData["Abstract"], CellFrame -> {{0, 0}, {0, 1}}, ShowCellBracket -> 
    False, CellMargins -> {{0, 0}, {12, 12}}, 
    CellFrameMargins -> {{30, 30}, {8, 8}}, ParagraphIndent -> 30]}, Visible -> 
  False, FrontEndVersion -> 
  "12.1 for Microsoft Windows (64-bit) (June 9, 2020)", StyleDefinitions -> 
  "PrivateStylesheetFormatting.nb"],
ExpressionUUID->"8da80095-f1ba-4283-b38b-4c159120fb2b"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 90, 0, 45, "Affiliation",ExpressionUUID->"4811c644-6998-4c62-aa30-611fb336dd4d"],
Cell[CellGroupData[{
Cell[673, 24, 80, 0, 90, "Title",ExpressionUUID->"eb403ecb-ed4d-40ce-b51f-21ff1c479205"],
Cell[756, 26, 118, 0, 57, "Subtitle",ExpressionUUID->"deb40e7c-e6b4-4c53-aea4-0895f9a28e37"],
Cell[877, 28, 199, 6, 57, "Subtitle",ExpressionUUID->"0fe6ea73-0865-4291-9e9c-5c07fc7fdaef"],
Cell[1079, 36, 244, 8, 57, "Subtitle",ExpressionUUID->"aa3e9479-cd1b-4260-86a8-4e3fc9b9e194"],
Cell[CellGroupData[{
Cell[1348, 48, 81, 0, 53, "Section",ExpressionUUID->"4115d32b-2208-4f95-8985-767fc1182068"],
Cell[CellGroupData[{
Cell[1454, 52, 1417, 58, 51, "Item",ExpressionUUID->"880fda2d-419c-4bde-b3f1-d4411c6b5ab0"],
Cell[2874, 112, 376, 11, 31, "Item",ExpressionUUID->"5eedd9aa-c1e6-4d7c-9fb1-569bc4cff424"],
Cell[3253, 125, 257, 6, 31, "Item",ExpressionUUID->"155a5025-f61d-4c41-a6af-18bd3b41450c"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[3559, 137, 94, 0, 53, "Section",ExpressionUUID->"ad852ca8-80ba-4f05-8b13-83b19437b715"],
Cell[CellGroupData[{
Cell[3678, 141, 261, 4, 51, "Item",ExpressionUUID->"e8cc0e04-47ba-480e-89b1-49777f82efa3"],
Cell[3942, 147, 129, 0, 31, "Item",ExpressionUUID->"3b88105c-37e6-4f14-ad03-f55fef00175a"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[4120, 153, 82, 0, 53, "Section",ExpressionUUID->"d3d292b2-25c7-4cd5-90a2-1b798112848e"],
Cell[CellGroupData[{
Cell[4227, 157, 91, 0, 41, "Subsection",ExpressionUUID->"73fb9c96-bbd5-4621-b5d2-03ca80ba2af6"],
Cell[4321, 159, 87, 0, 31, "Text",ExpressionUUID->"8f68af07-5ada-43df-9a18-b487faea5d47"],
Cell[4411, 161, 160, 3, 28, "Input",ExpressionUUID->"c10f474e-93e8-4e46-a553-11e0e849dbc7"],
Cell[4574, 166, 109, 0, 31, "Text",ExpressionUUID->"7f04c3bb-fdf6-4a90-a6be-7f3f52e496c7"],
Cell[CellGroupData[{
Cell[4708, 170, 139, 3, 28, "Input",ExpressionUUID->"e02b413f-01ab-4219-bb30-4a3e7d705adb"],
Cell[4850, 175, 130, 2, 32, "Output",ExpressionUUID->"66e988ee-f46a-4236-aedb-7e12e2ce2022"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5029, 183, 82, 0, 41, "Subsection",ExpressionUUID->"cc4d6c37-4ef9-4364-9445-57a36799e818"],
Cell[5114, 185, 92, 0, 31, "Text",ExpressionUUID->"218b0942-d3b5-41a8-9a2e-8824836de59b"],
Cell[CellGroupData[{
Cell[5231, 189, 222, 6, 28, "Input",ExpressionUUID->"a69eccc6-e72d-4728-9559-757e63a64c29"],
Cell[5456, 197, 338, 9, 32, "Output",ExpressionUUID->"e8503c2d-75a2-41ff-a5a3-c52e21c51f0c"]
}, Open  ]],
Cell[5809, 209, 97, 0, 31, "Text",ExpressionUUID->"ced77b85-1bc5-4796-a17c-f2ca3ca421cd"],
Cell[CellGroupData[{
Cell[5931, 213, 154, 3, 28, "Input",ExpressionUUID->"afdf01d1-448d-4a6e-a149-4db2388cca6c"],
Cell[6088, 218, 130, 2, 32, "Output",ExpressionUUID->"470f39a2-9055-4f20-be38-3983fed34ed2"]
}, Open  ]],
Cell[6233, 223, 331, 10, 31, "Text",ExpressionUUID->"29ba6cd4-49c8-4170-ab29-04a939f11bc6"],
Cell[CellGroupData[{
Cell[6589, 237, 289, 9, 28, "Input",ExpressionUUID->"bce2cfc3-c7db-4efa-8079-5211421b54f3"],
Cell[6881, 248, 338, 9, 32, "Output",ExpressionUUID->"40858f1a-a07f-46e1-9223-5fd2dd0ed85a"]
}, Open  ]],
Cell[7234, 260, 347, 10, 31, "Text",ExpressionUUID->"7787b66b-9a1b-43ad-805b-b48f7d3626bd"],
Cell[CellGroupData[{
Cell[7606, 274, 288, 8, 28, "Input",ExpressionUUID->"4c26a6e0-16f5-4971-9ec8-11319a04db5e"],
Cell[7897, 284, 184, 5, 45, "Output",ExpressionUUID->"e7254a76-528e-42a9-a586-8f6023396169"]
}, Open  ]],
Cell[8096, 292, 105, 0, 31, "Text",ExpressionUUID->"ac96bed3-2e93-4716-90ce-eb53a17dd490"],
Cell[CellGroupData[{
Cell[8226, 296, 290, 6, 31, "Input",ExpressionUUID->"666d1196-87bb-44a5-9824-513be8ee64aa"],
Cell[8519, 304, 253, 4, 32, "Output",ExpressionUUID->"414b949e-4a82-4298-85ee-5468461faaa0"]
}, Open  ]],
Cell[8787, 311, 118, 0, 31, "Text",ExpressionUUID->"0a3db1ac-9742-4de6-9e9c-4082c3cd36aa"],
Cell[CellGroupData[{
Cell[8930, 315, 355, 7, 31, "Input",ExpressionUUID->"958ceeff-a0be-452c-96aa-9a6b9856ef6f"],
Cell[9288, 324, 272, 4, 32, "Output",ExpressionUUID->"f8fa363c-a007-4789-820b-638624bf55c4"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9609, 334, 92, 0, 41, "Subsection",ExpressionUUID->"23b553f1-b112-483c-8045-2914b541df74"],
Cell[9704, 336, 250, 6, 31, "Text",ExpressionUUID->"1bc77fe8-34fc-44b2-a602-01fa2e30a327"],
Cell[CellGroupData[{
Cell[9979, 346, 144, 3, 28, "Input",ExpressionUUID->"7e84b30d-6099-4541-932b-73b59234837c"],
Cell[10126, 351, 485, 10, 21, "Message",ExpressionUUID->"00a20b07-940b-448b-9b5b-65b94ca01143"],
Cell[10614, 363, 117, 2, 32, "Output",ExpressionUUID->"5fb7ed8a-df96-4c25-95eb-7dd1169d3de2"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10768, 370, 145, 3, 28, "Input",ExpressionUUID->"879ff9b5-7127-4af1-add4-3a2413d42bde"],
Cell[10916, 375, 487, 10, 21, "Message",ExpressionUUID->"d9ca2d63-7d9f-48fa-8f26-e2f306f16b63"],
Cell[11406, 387, 117, 2, 32, "Output",ExpressionUUID->"cad5a5df-d0c0-4c0b-9de8-fed7902bdd46"]
}, Open  ]],
Cell[11538, 392, 506, 18, 31, "Text",ExpressionUUID->"05848441-558f-40cd-8317-935b228f9cd4"],
Cell[CellGroupData[{
Cell[12069, 414, 286, 8, 28, "Input",ExpressionUUID->"49879676-c97b-4b87-bea8-9fa73f5fab83"],
Cell[12358, 424, 382, 10, 32, "Output",ExpressionUUID->"fc4ef51a-b51b-4d11-9e00-5fc3ff81eb0d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[12777, 439, 289, 9, 28, "Input",ExpressionUUID->"2eab8010-5b33-4e3e-9af7-28a698b9c7f8"],
Cell[13069, 450, 382, 10, 32, "Output",ExpressionUUID->"dd0273c5-62f9-48a5-8e53-5d4bb6be5eb3"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13500, 466, 90, 0, 41, "Subsection",ExpressionUUID->"158b5bba-3784-4745-a7fd-3e0e96ad7008"],
Cell[13593, 468, 123, 0, 31, "Text",ExpressionUUID->"f58756c8-cc45-4cbc-9b6c-8b486e6517eb"],
Cell[CellGroupData[{
Cell[13741, 472, 680, 15, 53, "Input",ExpressionUUID->"cfad8c3f-afdc-4a11-973f-110d6120fefc"],
Cell[14424, 489, 403, 10, 45, "Output",ExpressionUUID->"a90d3e40-f2a1-4b85-8151-7eba40098800"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14888, 506, 82, 0, 53, "Chapter",ExpressionUUID->"0d542412-eca2-43f5-a66f-94b8d94546ca"],
Cell[14973, 508, 82, 0, 31, "Text",ExpressionUUID->"ebec6a58-adb0-419c-84af-7d8037665496"]
}, Open  ]],
Cell[CellGroupData[{
Cell[15092, 513, 83, 0, 53, "Chapter",ExpressionUUID->"17494725-bea5-40b1-b646-196e8ec719cc"],
Cell[15178, 515, 82, 0, 31, "Text",ExpressionUUID->"ba8d13b7-4aa9-4192-a804-a0823961829c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[15297, 520, 88, 0, 53, "Chapter",ExpressionUUID->"369e3b80-4eed-49ec-9d21-5569a9ad053b"],
Cell[15388, 522, 288, 7, 31, "Text",ExpressionUUID->"5ce41575-ddeb-4855-8a4e-c87a4a7b242d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[15713, 534, 91, 0, 53, "Chapter",ExpressionUUID->"5d4cf6d5-f2db-47a8-a854-ba3cfbd23f16"],
Cell[15807, 536, 82, 0, 31, "Text",ExpressionUUID->"0955e270-9660-4119-be78-4dc87f62a5c1"]
}, Open  ]],
Cell[CellGroupData[{
Cell[15926, 541, 87, 0, 53, "Chapter",ExpressionUUID->"276bdc99-eff6-4733-8c7c-7c40a3592e80"],
Cell[16016, 543, 82, 0, 31, "Item",ExpressionUUID->"479f8fb9-40f3-475f-a471-55e2a41b7d2b"],
Cell[16101, 545, 129, 0, 52, "Abstract",ExpressionUUID->"e19bb8a6-550e-44a6-8131-d71f1c21a151"]
}, Open  ]]
}, Open  ]]
}
]
*)

