(* ::Package:: *)

(* DO NOT EDIT THIS AUTOMATICALLY GENERATED FILE. *)


(* ::Input::Initialization:: *)
(* ::Title:: *)
(*ModelPaclet*)

(* ::Subtitle:: *)
(*An example of a simple toy paclet for \[LeftGuillemet]Online Meeting of Czech Mathematica Users'21\[RightGuillemet]*)


(* ::Input::Initialization:: *)
(* ::Chapter::Closed:: *)
(*Header*)

(* ::Subsection:: *)
(*Author*)
(* ::Text:: *)
(*Stanislav Hledik <stanislav.hledik@physics.slu.cz>*)

(* ::Subsection:: *)
(*Context(s) provided*)
(* ::Text:: *)
(*ModelPaclet`*)

(* ::Subsection:: *)
(*Development timeline*)
(* ::Item:: *)
(*2021-02-08: last improvements; documentation tuned*)
(* ::Item:: *)
(*2021-02-07: adapted for ModelPaclet*)
(* ::Item:: *)
(*2021-01-28: development commenced*)

(* ::Subsection:: *)
(*To-do list*)
(* ::Text:: *)
(*Sorted by decreasing priority*)
(* ::Item:: *)
(*\[LongDash]*)

(* ::Subsection:: *)
(*Dependences*)
(* ::Text:: *)
(*None*)

(* ::Subsection:: *)
(*Limitations*)
(* ::Text:: *)
(*WL version \[GreaterEqual] 12.1*)

(* ::Subsection:: *)
(*Keywords*)
(* ::Text:: *)
(*Wolfram Language; Mathematica; context; package; application; paclet*)
(* ::ItemNumbered:: *)
(*\[LongDash]: \[LongDash];\[LongDash].*)

(* ::Subsection:: *)
(*Credits*)
(* ::Text:: *)
(*All the code comes from the author with the following exceptions:*)
(* ::Item:: *)
(*\[LongDash]*)

(* ::Subsection:: *)
(*Copyright*)
(* ::Text:: *)
(*\[Copyright] 2021 Stanislav Hledik*)


(* ::Input::Initialization:: *)
(* ::Chapter::Closed:: *)
(*Opening*)

(* ::Text:: *)
(*Checks, abort for old, unsupported versions of Mathematica*)

(* ::Input:: *)
With[{p=Get["PacletInfo`",Path->DirectoryName[$InputFileName,2]]},
If[PacletNewerQ[
First[StringCases[p["WolframVersion"],NumberString]](* WolframVersion in PacletInfo *),
ToString[$VersionNumber]](* WolframVersion reported by system *),
Print[p["Name"]<>" requires WL version "<>p["WolframVersion"]];Abort[]]
];

BeginPackage["ModelPaclet`"];
Unprotect["ModelPaclet`*"];
ClearAll["ModelPaclet`*"];


(* ::Input::Initialization:: *)
(* ::Chapter::Closed:: *)
(*Usage messages*)

(* ::Text:: *)
(*Only usage statements are collected here.*)
(*They force export for the eponymous user functions defined within the Private context below,*)
(*extending their scope beyond the Private context.*)

(* ::Input:: *)
ModelPaclet::usage  = "ModelPaclet is an example of a simple toy paclet for instructional purposes.";

sayHello::usage  = "\
sayHello[] returns string \"Hello World!\".
sayHello[\!\(\*
StyleBox[\"str\", \"TI\"]\)] returns string \!\(\*
StyleBox[\"str\", \"TI\"]\) (shortened if too long).
sayHello[\!\(\*
StyleBox[\"str\", \"TI\"]\), \!\(\*
StyleBox[\"form\", \"TI\"]\)] applies formatting function \!\(\*
StyleBox[\"form\", \"TI\"]\) to the string returned.";


(* ::Input::Initialization:: *)
(* ::Chapter::Closed:: *)
(*Helper symbols*)

(* ::Text:: *)
(*Functions defined here (within the Private context) are not exported by an usage statement outside the Private context.*)
(*They are intended for internal use only, being user-invisible.*)

(* ::Input:: *)
Begin["`Private`"];

$defaultString="Hello World!";
$charsLR={24,48};

$stringShorten[s_String,{l_Integer?NonNegative,r_Integer?NonNegative}]/;(0<l+r<StringLength[s]):=StringJoin[StringTake[s,l],ToString[Skeleton[StringLength[s]-l-r]],StringTake[s,-r]]
$stringShorten[Missing[s_String,___],{l_Integer?NonNegative,r_Integer?NonNegative}]/;(0<l+r<StringLength[s]):=$stringShorten[s,{l,r}]
$stringShorten[s_String,a___]:=s
$stringShorten[Missing[s_String,___],a___]:=s


(* ::Input::Initialization:: *)
(* ::Chapter::Closed:: *)
(*Main definitions*)

(* ::Text:: *)
(*Exported functions intended for external (user) application.*)
(*Every function defined here has a corresponding usage statement defined above,*)
(*before the Private context, that extends its scope beyond the Private context.*)

(* ::Input:: *)
ModelPaclet::badarg = "`2`[`1`] does not match the rule base.";
SyntaxInformation[ModelPaclet]={"ArgumentsPattern"->{_,_,_.}};
ModelPaclet[a_List,name_String,ret_:$Failed]:=(Message[ModelPaclet::badarg,Row[a,","],name];Return[ret])

SyntaxInformation[sayHello]={"ArgumentsPattern"->{_.,_.}};
sayHello[str_String:$defaultString]:=$stringShorten[str,$charsLR]
sayHello[str_String:$defaultString,form:_Symbol|_Function|_Composition|_RightComposition]:=form[sayHello[str]]
sayHello[a___]:=ModelPaclet`ModelPaclet[{a},"sayHello"]


(* ::Input::Initialization:: *)
(* ::Chapter::Closed:: *)
(*Initialization code*)

(* ::Text:: *)
(*None*)


(* ::Input::Initialization:: *)
(* ::Chapter::Closed:: *)
(*Cleanup and completion*)

(* ::Text:: *)
(*Protect all package symbols*)

(* ::Input:: *)
With[{syms = Apply[Join,Map[Names,{"ModelPaclet`*"},Heads->False],Heads->False]},
SetAttributes[syms, {Protected, ReadProtected}]
];

(* ::Text:: *)
(*Print load message, complete the package and check for the absence of the ModelPaclet symbol in other contexts*)

(* ::Input:: *)
With[{p=Get["PacletInfo`",Path->DirectoryName[$InputFileName,2]]},
Print[p["Name"]<>"` v"<>p["Version"]];]
End[(*"`Private`"*)];
EndPackage[(*"ModelPaclet`"*)];
With[{s="ModelPaclet",c=Names["*`ModelPaclet",IgnoreCase->False,SpellingCorrection->False]},If[c=!={s},
Print[Apply[Sequence,Map[Style[#,Red]&,{"Symbol "<>s<>" appears in other contexts than "<>s<>"`: ",
DeleteCases[c,s,Heads->False]},Heads->False],Heads->False]]]];
