(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     26238,        680]
NotebookOptionsPosition[     23798,        623]
NotebookOutlinePosition[     24284,        642]
CellTagsIndexPosition[     24241,        639]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["ModelPaclet", "Title",ExpressionUUID->"ff59f640-5b35-4fc0-8d97-3a07adc3fa25"],

Cell["\<\
An example of a simple toy paclet for \[LeftGuillemet]Online Meeting of Czech \
Mathematica Users \[OpenCurlyQuote]21\[RightGuillemet]\
\>", "Subtitle",ExpressionUUID->"c6130c50-587b-4c86-b1d5-3138eb8fdafe"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"::", "Title", "::"}], " ", "*)"}], "\n", 
  RowBox[{"(*", "ModelPaclet", "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"::", "Subtitle", "::"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "An", " ", "example", " ", "of", " ", "a", " ", "simple", " ", "toy", " ", 
    "paclet", " ", "for", " ", "\[LeftGuillemet]Online", " ", "Meeting", " ", 
    "of", " ", "Czech", " ", "Mathematica", " ", 
    RowBox[{"Users", "'"}], "21", "\[RightGuillemet]"}], "*)"}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"3f738089-5e6d-4c95-b255-4109553fd103"],

Cell[CellGroupData[{

Cell["Header", "Section",ExpressionUUID->"9b449adb-914c-4f1e-8ee4-aee94413271f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"::", "Chapter", "::", "Closed", "::"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", "Header", "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"::", "Subsection", "::"}], " ", "*)"}], "\n", 
  RowBox[{"(*", "Author", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"::", "Text", "::"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"Stanislav", " ", "Hledik"}], " ", "<", 
    RowBox[{"stanislav", ".", 
     RowBox[{"hledik", "@", "physics"}], ".", "slu", ".", "cz"}], ">"}], 
   "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"::", "Subsection", "::"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"Context", 
    RowBox[{"(", "s", ")"}], " ", "provided"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"::", "Text", "::"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", "ModelPaclet`", "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"::", "Subsection", "::"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"Development", " ", "timeline"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"::", "Item", "::"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{"2021", "-", "02", "-", "08"}], ":", " ", 
     RowBox[{"last", " ", "improvements"}]}], ";", " ", 
    RowBox[{"documentation", " ", "tuned"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"::", "Item", "::"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"2021", "-", "02", "-", "07"}], ":", " ", 
    RowBox[{"adapted", " ", "for", " ", "ModelPaclet"}]}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"::", "Item", "::"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"2021", "-", "01", "-", "28"}], ":", " ", 
    RowBox[{"development", " ", "commenced"}]}], "*)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"::", "Subsection", "::"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"To", "-", 
    RowBox[{"do", " ", "list"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"::", "Text", "::"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"Sorted", " ", "by", " ", "decreasing", " ", "priority"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"::", "Item", "::"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", "\[LongDash]", "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"::", "Subsection", "::"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", "Dependences", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"::", "Text", "::"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", "None", "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"::", "Subsection", "::"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", "Limitations", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"::", "Text", "::"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"WL", " ", "version"}], " ", "\[GreaterEqual]", " ", "12.1"}], 
   "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"::", "Subsection", "::"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", "Keywords", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"::", "Text", "::"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"Wolfram", " ", "Language"}], ";", " ", "Mathematica", ";", " ", 
    "context", ";", " ", "package", ";", " ", "application", ";", " ", 
    "paclet"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"::", "ItemNumbered", "::"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"\[LongDash]", 
    RowBox[{":", " ", 
     RowBox[{"\[LongDash]", ";", "\[LongDash]", "."}]}]}], "*)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"::", "Subsection", "::"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", "Credits", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"::", "Text", "::"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "All", " ", "the", " ", "code", " ", "comes", " ", "from", " ", "the", " ",
     "author", " ", "with", " ", "the", " ", "following", " ", 
    RowBox[{"exceptions", ":"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"::", "Item", "::"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", "\[LongDash]", "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"::", "Subsection", "::"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", "Copyright", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"::", "Text", "::"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"\[Copyright]", " ", "2021", " ", "Stanislav", " ", "Hledik"}], 
   "*)"}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"439663ba-22c4-4e08-9090-2cf22890a35f"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Opening", "Section",ExpressionUUID->"f838803c-7c7d-4cd4-9c6e-dffaa0edbf62"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"::", "Chapter", "::", "Closed", "::"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", "Opening", "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"::", "Text", "::"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"Checks", ",", " ", 
    RowBox[{"abort", " ", "for", " ", "old"}], ",", " ", 
    RowBox[{"unsupported", " ", "versions", " ", "of", " ", "Mathematica"}]}],
    "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"::", "Input", "::"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"With", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"p", "=", 
        RowBox[{"Get", "[", 
         RowBox[{"\"\<PacletInfo`\>\"", ",", 
          RowBox[{"Path", "\[Rule]", 
           RowBox[{"DirectoryName", "[", 
            RowBox[{"$InputFileName", ",", "2"}], "]"}]}]}], "]"}]}], "}"}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"PacletNewerQ", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"First", "[", 
           RowBox[{"StringCases", "[", 
            RowBox[{
             RowBox[{"p", "[", "\"\<WolframVersion\>\"", "]"}], ",", 
             "NumberString"}], "]"}], "]"}], 
          RowBox[{"(*", " ", 
           RowBox[{"WolframVersion", " ", "in", " ", "PacletInfo"}], " ", 
           "*)"}], ",", "\[IndentingNewLine]", 
          RowBox[{"ToString", "[", "$VersionNumber", "]"}]}], "]"}], 
        RowBox[{"(*", " ", 
         RowBox[{
         "WolframVersion", " ", "reported", " ", "by", " ", "system"}], " ", 
         "*)"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Print", "[", 
          RowBox[{
           RowBox[{"p", "[", "\"\<Name\>\"", "]"}], "<>", 
           "\"\< requires WL version \>\"", "<>", 
           RowBox[{"p", "[", "\"\<WolframVersion\>\"", "]"}]}], "]"}], ";", 
         RowBox[{"Abort", "[", "]"}]}]}], "]"}]}], "\[IndentingNewLine]", 
     "]"}], ";"}], "\[IndentingNewLine]", "\n", 
   RowBox[{
    RowBox[{"BeginPackage", "[", "\"\<ModelPaclet`\>\"", "]"}], ";"}], "\n", 
   RowBox[{
    RowBox[{"Unprotect", "[", "\"\<ModelPaclet`*\>\"", "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ClearAll", "[", "\"\<ModelPaclet`*\>\"", "]"}], 
    ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"1f77725f-f0be-4a63-8ff7-dee85cc3de0d"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Usage messages", "Section",ExpressionUUID->"5a3641a4-26c4-453b-837f-f987b5033daf"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"::", "Chapter", "::", "Closed", "::"}], " ", "*)"}], "\n", 
  RowBox[{"(*", 
   RowBox[{"Usage", " ", "messages"}], "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"::", "Text", "::"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "Only", " ", "usage", " ", "statements", " ", "are", " ", "collected", " ", 
    RowBox[{"here", "."}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "They", " ", "force", " ", "export", " ", "for", " ", "the", " ", 
     "eponymous", " ", "user", " ", "functions", " ", "defined", " ", 
     "within", " ", "the", " ", "Private", " ", "context", " ", "below"}], 
    ","}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "extending", " ", "their", " ", "scope", " ", "beyond", " ", "the", " ", 
    "Private", " ", 
    RowBox[{"context", "."}]}], "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"::", "Input", "::"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"ModelPaclet", "::", "usage"}], "  ", "=", " ", 
     "\"\<ModelPaclet is an example of a simple toy paclet for instructional \
purposes.\>\""}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"sayHello", "::", "usage"}], "  ", "=", " ", 
     "\"\<\\\nsayHello[] returns string \\\"Hello World!\\\".\n\
sayHello[\!\(\*StyleBox[\"str\", \"TI\"]\)] returns string \
\!\(\*StyleBox[\"str\", \"TI\"]\) (shortened if too long).\n\
sayHello[\!\(\*StyleBox[\"str\", \"TI\"]\), \!\(\*StyleBox[\"form\", \
\"TI\"]\)] applies formatting function \!\(\*StyleBox[\"form\", \"TI\"]\) to \
the string returned.\>\""}], ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"c1f0013c-dc8c-44ae-90bb-78b1f46928e1"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Helper symbols", "Section",ExpressionUUID->"c90cda9d-91cb-4c8d-87a2-76a033c82774"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"::", "Chapter", "::", "Closed", "::"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"Helper", " ", "symbols"}], "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"::", "Text", "::"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"Functions", " ", "defined", " ", "here", " ", 
    RowBox[{"(", 
     RowBox[{"within", " ", "the", " ", "Private", " ", "context"}], ")"}], 
    " ", "are", " ", "not", " ", "exported", " ", "by", " ", "an", " ", 
    "usage", " ", "statement", " ", "outside", " ", "the", " ", "Private", 
    " ", 
    RowBox[{"context", "."}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "They", " ", "are", " ", "intended", " ", "for", " ", "internal", " ", 
     "use", " ", "only"}], ",", " ", 
    RowBox[{
     RowBox[{"being", " ", "user"}], "-", 
     RowBox[{"invisible", "."}]}]}], "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"::", "Input", "::"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Begin", "[", "\"\<`Private`\>\"", "]"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"$defaultString", "=", "\"\<Hello World!\>\""}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"$charsLR", "=", 
     RowBox[{"{", 
      RowBox[{"24", ",", "48"}], "}"}]}], ";"}], "\n", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"$stringShorten", "[", 
      RowBox[{"s_String", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"l_Integer", "?", "NonNegative"}], ",", 
         RowBox[{"r_Integer", "?", "NonNegative"}]}], "}"}]}], "]"}], "/;", 
     RowBox[{"(", 
      RowBox[{"0", "<", 
       RowBox[{"l", "+", "r"}], "<", 
       RowBox[{"StringLength", "[", "s", "]"}]}], ")"}]}], ":=", 
    RowBox[{"StringJoin", "[", 
     RowBox[{
      RowBox[{"StringTake", "[", 
       RowBox[{"s", ",", "l"}], "]"}], ",", 
      RowBox[{"ToString", "[", 
       RowBox[{"Skeleton", "[", 
        RowBox[{
         RowBox[{"StringLength", "[", "s", "]"}], "-", "l", "-", "r"}], "]"}],
        "]"}], ",", 
      RowBox[{"StringTake", "[", 
       RowBox[{"s", ",", 
        RowBox[{"-", "r"}]}], "]"}]}], "]"}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"$stringShorten", "[", 
      RowBox[{
       RowBox[{"Missing", "[", 
        RowBox[{"s_String", ",", "___"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"l_Integer", "?", "NonNegative"}], ",", 
         RowBox[{"r_Integer", "?", "NonNegative"}]}], "}"}]}], "]"}], "/;", 
     RowBox[{"(", 
      RowBox[{"0", "<", 
       RowBox[{"l", "+", "r"}], "<", 
       RowBox[{"StringLength", "[", "s", "]"}]}], ")"}]}], ":=", 
    RowBox[{"$stringShorten", "[", 
     RowBox[{"s", ",", 
      RowBox[{"{", 
       RowBox[{"l", ",", "r"}], "}"}]}], "]"}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"$stringShorten", "[", 
     RowBox[{"s_String", ",", "a___"}], "]"}], ":=", "s"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"$stringShorten", "[", 
     RowBox[{
      RowBox[{"Missing", "[", 
       RowBox[{"s_String", ",", "___"}], "]"}], ",", "a___"}], "]"}], ":=", 
    "s"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"dc49a97f-e2c5-4db6-9940-733f5502882d"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Main definitions", "Section",ExpressionUUID->"e94f6a11-db0e-44e5-9cc8-7a00f68aa8a7"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"::", "Chapter", "::", "Closed", "::"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"Main", " ", "definitions"}], "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"::", "Text", "::"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "Exported", " ", "functions", " ", "intended", " ", "for", " ", "external",
     " ", 
    RowBox[{"(", "user", ")"}], " ", 
    RowBox[{"application", "."}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "Every", " ", "function", " ", "defined", " ", "here", " ", "has", " ", 
     "a", " ", "corresponding", " ", "usage", " ", "statement", " ", 
     "defined", " ", "above"}], ","}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"before", " ", "the", " ", "Private", " ", "context"}], ",", " ", 
    RowBox[{
    "that", " ", "extends", " ", "its", " ", "scope", " ", "beyond", " ", 
     "the", " ", "Private", " ", 
     RowBox[{"context", "."}]}]}], "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"::", "Input", "::"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"ModelPaclet", "::", "badarg"}], " ", "=", " ", 
     "\"\<`2`[`1`] does not match the rule base.\>\""}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"SyntaxInformation", "[", "ModelPaclet", "]"}], "=", 
     RowBox[{"{", 
      RowBox[{"\"\<ArgumentsPattern\>\"", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"_", ",", "_", ",", "_."}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ModelPaclet", "[", 
     RowBox[{"a_List", ",", "name_String", ",", 
      RowBox[{"ret_", ":", "$Failed"}]}], "]"}], ":=", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Message", "[", 
       RowBox[{
        RowBox[{"ModelPaclet", "::", "badarg"}], ",", 
        RowBox[{"Row", "[", 
         RowBox[{"a", ",", "\"\<,\>\""}], "]"}], ",", "name"}], "]"}], ";", 
      RowBox[{"Return", "[", "ret", "]"}]}], ")"}]}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"SyntaxInformation", "[", "sayHello", "]"}], "=", 
     RowBox[{"{", 
      RowBox[{"\"\<ArgumentsPattern\>\"", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"_.", ",", "_."}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"sayHello", "[", 
     RowBox[{"str_String", ":", "$defaultString"}], "]"}], ":=", 
    RowBox[{"$stringShorten", "[", 
     RowBox[{"str", ",", "$charsLR"}], "]"}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"sayHello", "[", 
     RowBox[{
      RowBox[{"str_String", ":", "$defaultString"}], ",", 
      RowBox[{"form", ":", 
       RowBox[{
       "_Symbol", "|", "_Function", "|", "_Composition", "|", 
        "_RightComposition"}]}]}], "]"}], ":=", 
    RowBox[{"form", "[", 
     RowBox[{"sayHello", "[", "str", "]"}], "]"}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"sayHello", "[", "a___", "]"}], ":=", 
    RowBox[{"ModelPaclet`ModelPaclet", "[", 
     RowBox[{
      RowBox[{"{", "a", "}"}], ",", "\"\<sayHello\>\""}], 
     "]"}]}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"dd10e191-e91b-4e9f-8777-37230c26d736"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Initialization code", "Section",ExpressionUUID->"86df96b1-eaa9-413a-9452-9cb87bc4ee7d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"::", "Chapter", "::", "Closed", "::"}], " ", "*)"}], "\n", 
  RowBox[{"(*", 
   RowBox[{"Initialization", " ", "code"}], "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"::", "Text", "::"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", "None", "*)"}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"5900db8f-8225-4874-91fb-fb00b1ee07ef"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Cleanup and completion", "Section",ExpressionUUID->"8a066cd7-80ab-433e-baf8-0dfdbf61592f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"::", "Chapter", "::", "Closed", "::"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"Cleanup", " ", "and", " ", "completion"}], "*)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"::", "Text", "::"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"Protect", " ", "all", " ", "package", " ", "symbols"}], "*)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"::", "Input", "::"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"With", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"syms", " ", "=", " ", 
        RowBox[{"Apply", "[", 
         RowBox[{"Join", ",", 
          RowBox[{"Map", "[", 
           RowBox[{"Names", ",", 
            RowBox[{"{", "\"\<ModelPaclet`*\>\"", "}"}], ",", 
            RowBox[{"Heads", "\[Rule]", "False"}]}], "]"}], ",", 
          RowBox[{"Heads", "\[Rule]", "False"}]}], "]"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"SetAttributes", "[", 
       RowBox[{"syms", ",", " ", 
        RowBox[{"{", 
         RowBox[{"Protected", ",", " ", "ReadProtected"}], "}"}]}], "]"}]}], 
     "\[IndentingNewLine]", "]"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"::", "Text", "::"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"Print", " ", "load", " ", "message"}], ",", " ", 
     RowBox[{
     "complete", " ", "the", " ", "package", " ", "and", " ", "check", " ", 
      "for", " ", "the", " ", "absence", " ", "of", " ", "the", " ", 
      "ModelPaclet", " ", "symbol", " ", "in", " ", "other", " ", 
      "contexts"}]}], "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"::", "Input", "::"}], " ", "*)"}], "\n", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"p", "=", 
       RowBox[{"Get", "[", 
        RowBox[{"\"\<PacletInfo`\>\"", ",", 
         RowBox[{"Path", "\[Rule]", 
          RowBox[{"DirectoryName", "[", 
           RowBox[{"$InputFileName", ",", "2"}], "]"}]}]}], "]"}]}], "}"}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Print", "[", 
       RowBox[{
        RowBox[{"p", "[", "\"\<Name\>\"", "]"}], "<>", "\"\<` v\>\"", "<>", 
        RowBox[{"p", "[", "\"\<Version\>\"", "]"}]}], "]"}], ";"}]}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"End", "[", 
     RowBox[{"(*", "\"\<`Private`\>\"", "*)"}], "]"}], ";"}], "\n", 
   RowBox[{
    RowBox[{"EndPackage", "[", 
     RowBox[{"(*", "\"\<ModelPaclet`\>\"", "*)"}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"With", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"s", "=", "\"\<ModelPaclet\>\""}], ",", 
        RowBox[{"c", "=", 
         RowBox[{"Names", "[", 
          RowBox[{"\"\<*`ModelPaclet\>\"", ",", 
           RowBox[{"IgnoreCase", "\[Rule]", "False"}], ",", 
           RowBox[{"SpellingCorrection", "\[Rule]", "False"}]}], "]"}]}]}], 
       "}"}], ",", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"c", "=!=", 
         RowBox[{"{", "s", "}"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{"Print", "[", 
         RowBox[{"Apply", "[", 
          RowBox[{"Sequence", ",", 
           RowBox[{"Map", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"Style", "[", 
               RowBox[{"#", ",", "Red"}], "]"}], "&"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{
               "\"\<Symbol \>\"", "<>", "s", "<>", 
                "\"\< appears in other contexts than \>\"", "<>", "s", "<>", 
                "\"\<`: \>\""}], ",", "\[IndentingNewLine]", 
               RowBox[{"DeleteCases", "[", 
                RowBox[{"c", ",", "s", ",", 
                 RowBox[{"Heads", "\[Rule]", "False"}]}], "]"}]}], "}"}], ",", 
             RowBox[{"Heads", "\[Rule]", "False"}]}], "]"}], ",", 
           RowBox[{"Heads", "\[Rule]", "False"}]}], "]"}], "]"}]}], "]"}]}], 
     "]"}], ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"438aa27c-1d65-4e2d-8ca7-7e6dedde788e"]
}, Open  ]]
}, Open  ]]
},
AutoGeneratedPackage->Automatic,
WindowToolbars->"EditBar",
WindowSize->{1197, 1022},
WindowMargins->{{1, Automatic}, {Automatic, 0}},
TrackCellChangeTimes->False,
FrontEndVersion->"12.1 for Microsoft Windows (64-bit) (June 9, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"1914ac54-78d1-467a-9317-d0b3da84e1ac"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 83, 0, 96, "Title",ExpressionUUID->"ff59f640-5b35-4fc0-8d97-3a07adc3fa25"],
Cell[666, 24, 217, 3, 53, "Subtitle",ExpressionUUID->"c6130c50-587b-4c86-b1d5-3138eb8fdafe"],
Cell[886, 29, 683, 15, 121, "Input",ExpressionUUID->"3f738089-5e6d-4c95-b255-4109553fd103",
 InitializationCell->True],
Cell[CellGroupData[{
Cell[1594, 48, 80, 0, 67, "Section",ExpressionUUID->"9b449adb-914c-4f1e-8ee4-aee94413271f"],
Cell[1677, 50, 5398, 122, 1109, "Input",ExpressionUUID->"439663ba-22c4-4e08-9090-2cf22890a35f",
 InitializationCell->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[7112, 177, 81, 0, 67, "Section",ExpressionUUID->"f838803c-7c7d-4cd4-9c6e-dffaa0edbf62"],
Cell[7196, 179, 2515, 62, 362, "Input",ExpressionUUID->"1f77725f-f0be-4a63-8ff7-dee85cc3de0d",
 InitializationCell->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[9748, 246, 88, 0, 67, "Section",ExpressionUUID->"5a3641a4-26c4-453b-837f-f987b5033daf"],
Cell[9839, 248, 1912, 44, 311, "Input",ExpressionUUID->"c1f0013c-dc8c-44ae-90bb-78b1f46928e1",
 InitializationCell->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[11788, 297, 88, 0, 67, "Section",ExpressionUUID->"c90cda9d-91cb-4c8d-87a2-76a033c82774"],
Cell[11879, 299, 3429, 93, 368, "Input",ExpressionUUID->"dc49a97f-e2c5-4db6-9940-733f5502882d",
 InitializationCell->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[15345, 397, 90, 0, 67, "Section",ExpressionUUID->"e94f6a11-db0e-44e5-9cc8-7a00f68aa8a7"],
Cell[15438, 399, 3348, 88, 356, "Input",ExpressionUUID->"dd10e191-e91b-4e9f-8777-37230c26d736",
 InitializationCell->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[18823, 492, 93, 0, 67, "Section",ExpressionUUID->"86df96b1-eaa9-413a-9452-9cb87bc4ee7d"],
Cell[18919, 494, 457, 11, 121, "Input",ExpressionUUID->"5900db8f-8225-4874-91fb-fb00b1ee07ef",
 InitializationCell->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[19413, 510, 96, 0, 67, "Section",ExpressionUUID->"8a066cd7-80ab-433e-baf8-0dfdbf61592f"],
Cell[19512, 512, 4258, 107, 449, "Input",ExpressionUUID->"438aa27c-1d65-4e2d-8ca7-7e6dedde788e",
 InitializationCell->True]
}, Open  ]]
}, Open  ]]
}
]
*)

