(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     20943,        514]
NotebookOptionsPosition[     19482,        477]
NotebookOutlinePosition[     19935,        495]
CellTagsIndexPosition[     19892,        492]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Paclet Info", "Title",ExpressionUUID->"1e64afb1-1dc4-425a-b033-6e7a0f8f07ac"],

Cell[CellGroupData[{

Cell["\<\
This notebook must be placed in the same location as PacletInfo.wl is \
expected.\
\>", "Item",ExpressionUUID->"2e243ab8-42c4-472d-a4ea-5f5a2de90c28"],

Cell[TextData[{
 "Visit ",
 ButtonBox["https://www.wolframcloud.com/obj/tgayley/Published/\
PacletDevelopment.nb",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["https://www.wolframcloud.com/obj/tgayley/Published/PacletDevelopment.\
nb"], None},
  ButtonNote->
   "https://www.wolframcloud.com/obj/tgayley/Published/PacletDevelopment.nb"],
 "  and ",
 ButtonBox["PacletObject",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/PacletObject"],
 " documentation for detailed info about PacletObject fields."
}], "Item",ExpressionUUID->"42c71cee-34b3-4784-930b-4b2dca52bed6"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Edit and evaluate to generate PacletObject.wl", "Section",ExpressionUUID->"97ae411f-e03e-4906-8035-27821ff9ce1c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"p", "=", 
      RowBox[{
       RowBox[{"StringDrop", "[", 
        RowBox[{
         RowBox[{"NotebookFileName", "[", "]"}], ",", 
         RowBox[{"-", "2"}]}], "]"}], "<>", "\"\<wl\>\""}]}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"Put", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"PacletObject", "[", 
       RowBox[{"\[LeftAssociation]", "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{
          RowBox[{
          "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
            "**"}], "*"}], " ", "*)"}], "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{
          RowBox[{
           RowBox[{"<<", 
            RowBox[{"<<", " ", "TWO"}]}], " ", "REQUIRED", " ", "FIELDS"}], 
          " ", ">>>", ">"}], " ", "*)"}], "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{
          RowBox[{
          "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
            "**"}], "*"}], " ", "*)"}], "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{
          RowBox[{"--", " ", "name"}], " ", "of", " ", "the", " ", "paclet", 
          " ", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
            "need", " ", "not", " ", "match", " ", "the", " ", "name", " ", 
             "of", " ", "a", " ", 
             RowBox[{"context", "/", "file"}], " ", "your", " ", "paclet", 
             " ", "provides"}], ")"}], " ", "--"}]}], " ", "*)"}], 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"\"\<Name\>\"", "\[Rule]", "\"\<ModelPaclet\>\""}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"(*", " ", 
          RowBox[{
           RowBox[{"--", " ", "paclet"}], " ", "version", " ", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
             "string", " ", "up", " ", "to", " ", "five", " ", "digit", " ", 
              "blocks"}], ")"}], " ", "--"}]}], " ", "*)"}], 
         "\[IndentingNewLine]", 
         RowBox[{"\"\<Version\>\"", "\[Rule]", "\"\<1.0\>\""}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"(*", " ", 
          RowBox[{
           RowBox[{
           "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
             "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", 
            "**"}], "*"}], " ", "*)"}], "\[IndentingNewLine]", 
         RowBox[{"(*", " ", 
          RowBox[{
           RowBox[{
            RowBox[{"<<", 
             RowBox[{"<<", " ", "ANYTHING"}]}], " ", "EXTRA", " ", "BELOW", 
            " ", "THIS", " ", "LINE", " ", "IS", " ", "OPTIONAL"}], " ", ">>>",
            ">"}], " ", "*)"}], "\[IndentingNewLine]", 
         RowBox[{"(*", " ", 
          RowBox[{
           RowBox[{
           "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
             "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", 
            "**"}], "*"}], " ", "*)"}], "\[IndentingNewLine]", 
         RowBox[{"(*", " ", 
          RowBox[{
           RowBox[{"--", " ", "what"}], " ", "version", 
           RowBox[{"(", "s", ")"}], " ", "of", " ", "the", " ", "WL", " ", 
           "the", " ", "paclet", " ", "is", " ", "compatible", " ", 
           RowBox[{"with", " ", "--"}]}], " ", "*)"}], "\[IndentingNewLine]", 
         RowBox[{"\"\<WolframVersion\>\"", "\[Rule]", "\"\<12.1+\>\""}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"(*", " ", 
          RowBox[{
           RowBox[{"--", " ", "what"}], " ", "$SystemID", " ", "values", " ", 
           "the", " ", "paclet", " ", "is", " ", "compatible", " ", "with", 
           " ", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
             "All", ",", " ", "\"\<Windows-x86-64\>\"", ",", " ", "..."}], 
             ")"}], " ", "--"}]}], " ", "*)"}], "\[IndentingNewLine]", 
         RowBox[{"(*", 
          RowBox[{
           RowBox[{"\"\<SystemID\>\"", "\[Rule]", "All"}], ","}], "*)"}], 
         "\[IndentingNewLine]", 
         RowBox[{"(*", " ", 
          RowBox[{
           RowBox[{"--", " ", "the"}], " ", "name", " ", "of", " ", "the", 
           " ", "product", " ", "the", " ", "paclet", " ", "is", " ", 
           "restricted", " ", "to", " ", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
             "All", ",", " ", 
              "\"\<\!\(\*StyleBox[\"Mathematica\", \"ExampleText\"]\)\>\""}], 
             ")"}], " ", "--"}]}], " ", "*)"}], "\[IndentingNewLine]", 
         RowBox[{"(*", 
          RowBox[{
           RowBox[{
           "\"\<ProductID\>\"", "\[Rule]", 
            "\"\<\!\(\*StyleBox[\"Mathematica\", \"ExampleText\"]\)\>\""}], 
           ","}], "*)"}], "\[IndentingNewLine]", 
         RowBox[{"(*", " ", 
          RowBox[{
           RowBox[{"--", " ", "the"}], " ", "location", " ", "of", " ", "the",
            " ", "contents", " ", "relative", " ", "to", " ", "the", " ", 
           StyleBox[
            RowBox[{"PacletInfo", ".", "wl"}], "InlineCode"], 
           StyleBox[" ", "InlineCode"], 
           RowBox[{"file", " ", "--"}]}], " ", "*)"}], "\[IndentingNewLine]", 
         RowBox[{"\"\<Root\>\"", "\[Rule]", "\"\<.\>\""}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"(*", " ", 
          RowBox[{
           RowBox[{"--", " ", "when"}], " ", "the", " ", 
           RowBox[{"paclet", "'"}], 
           RowBox[{"s", " ", ".", "wl"}], " ", 
           RowBox[{"or", " ", ".", "m"}], " ", "files", " ", 
           RowBox[{"load", " ", "--"}]}], " ", "*)"}], "\[IndentingNewLine]", 
         RowBox[{"\"\<Loading\>\"", "\[Rule]", "Manual"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"(*", " ", 
          RowBox[{
           RowBox[{"--", " ", "whether"}], " ", "the", " ", "paclet", " ", 
           "automatically", " ", "updates", " ", 
           RowBox[{"itself", " ", "--"}]}], " ", "*)"}], 
         "\[IndentingNewLine]", 
         RowBox[{"\"\<AutoUpdating\>\"", "\[Rule]", "False"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"(*", " ", 
          RowBox[{
           RowBox[{"--", " ", "short"}], " ", "description", " ", "of", " ", 
           "the", " ", 
           RowBox[{"paclet", " ", "--"}]}], " ", "*)"}], 
         "\[IndentingNewLine]", 
         RowBox[{
         "\"\<Description\>\"", "\[Rule]", 
          "\"\<An example of a simple toy paclet for instructional \
purposes.\>\""}], ",", "\[IndentingNewLine]", 
         RowBox[{"(*", " ", 
          RowBox[{
           RowBox[{"--", " ", "a"}], " ", "category", " ", "or", " ", "list", 
           " ", "of", " ", "categories", " ", "describing", " ", "the", " ", 
           RowBox[{"functionality", " ", "--"}]}], " ", "*)"}], 
         "\[IndentingNewLine]", 
         RowBox[{"\"\<Category\>\"", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
           "\"\<Instruction\>\"", ",", "\"\<Paclet System\>\"", ",", 
            "\"\<Context\>\""}], "}"}]}], ",", "\[IndentingNewLine]", 
         RowBox[{"(*", " ", 
          RowBox[{
           RowBox[{"--", " ", "keywords"}], " ", "relevant", " ", "to", " ", 
           "the", " ", 
           RowBox[{"functionality", " ", "--"}]}], " ", "*)"}], 
         "\[IndentingNewLine]", 
         RowBox[{"\"\<Keywords\>\"", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
           "\"\<paclet\>\"", ",", "\"\<building\>\"", ",", 
            "\"\<documentation\>\"", ",", "\"\<context\>\""}], "}"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"(*", " ", 
          RowBox[{
           RowBox[{"--", " ", "author"}], " ", "or", " ", "company", " ", 
           RowBox[{"information", " ", "--"}]}], " ", "*)"}], 
         "\[IndentingNewLine]", 
         RowBox[{
         "\"\<Creator\>\"", "\[Rule]", 
          "\"\<Stanislav Hledik <hlediks@gmail.com>\>\""}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"(*", " ", 
          RowBox[{
           RowBox[{"--", " ", "publisher"}], " ", 
           RowBox[{"information", " ", "--"}]}], " ", "*)"}], 
         "\[IndentingNewLine]", 
         RowBox[{"(*", 
          RowBox[{
           RowBox[{"\"\<Publisher\>\"", "\[Rule]", "\"\<\>\""}], ","}], 
          "*)"}], "\[IndentingNewLine]", 
         RowBox[{"(*", " ", 
          RowBox[{
           RowBox[{"--", " ", "a"}], " ", "URL", " ", "to", " ", "a", " ", 
           "home", " ", "page", " ", "for", " ", "the", " ", 
           RowBox[{"paclet", " ", "--"}]}], " ", "*)"}], 
         "\[IndentingNewLine]", 
         RowBox[{
         "\"\<URL\>\"", "\[Rule]", 
          "\"\<https://is.slu.cz/www/hle0002/test/sum21\>\""}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"(*", " ", 
          RowBox[{
           RowBox[{
            RowBox[{"--", " ", "the"}], " ", "location", " ", "of", " ", 
            "the", " ", "paclet"}], ",", " ", 
           RowBox[{
           "either", " ", "a", " ", "local", " ", "path", " ", "or", " ", "a",
             " ", "paclet", " ", "site", " ", 
            RowBox[{"URL", " ", "--"}]}]}], " ", "*)"}], 
         "\[IndentingNewLine]", 
         RowBox[{
         "\"\<Location\>\"", "\[Rule]", 
          "\"\<https://is.slu.cz/www/hle0002/test/sum21\>\""}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"(*", " ", 
          RowBox[{
           RowBox[{"--", " ", "where"}], " ", "to", " ", "go", " ", "for", 
           " ", 
           RowBox[{"support", " ", "--"}]}], " ", "*)"}], 
         "\[IndentingNewLine]", 
         RowBox[{
         "\"\<Support\>\"", "\[Rule]", 
          "\"\<https://is.slu.cz/www/hle0002/test/sum21/support\>\""}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"(*", " ", 
          RowBox[{
           RowBox[{"--", " ", "relative"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"w", ".", "r", ".", " ", "to"}], " ", "paclet", " ", 
             "\"\<Root\>\""}], ")"}], " ", "path", " ", "to", " ", "a", " ", 
           "file", " ", "containing", " ", "an", " ", "icon", " ", 
           RowBox[{"image", " ", "--"}]}], " ", "*)"}], "\[IndentingNewLine]", 
         RowBox[{
         "\"\<Icon\>\"", "\[Rule]", "\"\<Resources/Icons/Icon.png\>\""}], ",",
          "\[IndentingNewLine]", 
         RowBox[{"(*", " ", 
          RowBox[{
           RowBox[{"--", " ", "a"}], " ", "unique", " ", 
           RowBox[{"ID", " ", "--"}]}], " ", "*)"}], "\[IndentingNewLine]", 
         RowBox[{"(*", 
          RowBox[{
           RowBox[{"\"\<UUID\>\"", "\[Rule]", "\"\<\>\""}], ","}], "*)"}], 
         "\[IndentingNewLine]", 
         RowBox[{"(*", " ", 
          RowBox[{
           RowBox[{"--", " ", "specification"}], " ", "of", " ", "what", " ", 
           "the", " ", "paclet", " ", 
           RowBox[{"provides", " ", "--"}]}], " ", "*)"}], 
         "\[IndentingNewLine]", 
         RowBox[{"\"\<Extensions\>\"", "\[Rule]", 
          RowBox[{"{", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"\"\<Kernel\>\"", ",", "\[IndentingNewLine]", 
              RowBox[{"\"\<Root\>\"", "\[Rule]", "\"\<Kernel\>\""}], ",", 
              RowBox[{"\"\<Context\>\"", "\[Rule]", 
               RowBox[{"{", "\"\<ModelPaclet`\>\"", "}"}]}]}], 
             "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
            RowBox[{"(*", 
             RowBox[{
              RowBox[{"{", "\"\<FrontEnd\>\"", "}"}], ","}], "*)"}], 
            "\[IndentingNewLine]", 
            RowBox[{"{", "\"\<Path\>\"", "}"}], ",", "\[IndentingNewLine]", 
            RowBox[{"{", 
             RowBox[{"\"\<Documentation\>\"", ",", "\[IndentingNewLine]", 
              RowBox[{"\"\<Root\>\"", "\[Rule]", "\"\<Documentation\>\""}], 
              ",", 
              RowBox[{"\"\<Language\>\"", "\[Rule]", "\"\<English\>\""}], ",", 
              RowBox[{
              "\"\<MainPage\>\"", "\[Rule]", "\"\<Guides/ModelPaclet\>\""}], 
              ",", 
              RowBox[{"\"\<LinkBase\>\"", "\[Rule]", "\"\<ModelPaclet\>\""}], 
              ",", "\[IndentingNewLine]", 
              RowBox[{"\"\<Resources\>\"", "\[Rule]", 
               RowBox[{"{", "\[IndentingNewLine]", 
                RowBox[{
                "\"\<Guides/ModelPaclet\>\"", ",", "\[IndentingNewLine]", 
                 "\"\<ReferencePages/Symbols/sayHello\>\""}], 
                "\[IndentingNewLine]", "}"}]}]}], "\[IndentingNewLine]", 
             "}"}], ",", "\[IndentingNewLine]", 
            RowBox[{"(*", 
             RowBox[{
              RowBox[{"{", "\"\<LibraryLink\>\"", "}"}], ","}], "*)"}], 
            "\[IndentingNewLine]", 
            RowBox[{"(*", 
             RowBox[{
              RowBox[{"{", "\"\<JLink\>\"", "}"}], ","}], "*)"}], 
            "\[IndentingNewLine]", 
            RowBox[{"{", 
             RowBox[{"\"\<Resource\>\"", ",", "\[IndentingNewLine]", 
              RowBox[{"\"\<Root\>\"", "\[Rule]", "\"\<Resources\>\""}], ",", 
              RowBox[{"(*", 
               RowBox[{
                RowBox[{
                "\"\<SystemID\>\"", " ", "\[Rule]", " ", 
                 "\"\<Windows-x86-64\>\""}], ","}], "*)"}], 
              "\[IndentingNewLine]", 
              RowBox[{"\"\<Resources\>\"", "\[Rule]", 
               RowBox[{"{", "\[IndentingNewLine]", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"\"\<Icon\>\"", ",", "\"\<Icons/Icon.png\>\""}], 
                  "}"}], ",", "\[IndentingNewLine]", 
                 RowBox[{"{", 
                  RowBox[{
                  "\"\<IconBig\>\"", ",", "\"\<Icons/IconBig.png\>\""}], 
                  "}"}], ",", "\[IndentingNewLine]", 
                 RowBox[{"{", 
                  RowBox[{
                  "\"\<DirectoryStructure\>\"", ",", 
                   "\"\<DataFiles/DirectoryStructure.zip\>\""}], "}"}]}], 
                "\[IndentingNewLine]", "}"}]}]}], "\[IndentingNewLine]", 
             "}"}], 
            RowBox[{"(*", " ", "Resource", " ", "*)"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"{", 
             RowBox[{"\"\<Resource\>\"", ",", "\[IndentingNewLine]", 
              RowBox[{"\"\<Root\>\"", "\[Rule]", "\"\<.\>\""}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"\"\<Resources\>\"", "\[Rule]", 
               RowBox[{"{", "\[IndentingNewLine]", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"\"\<Kernel\>\"", ",", "\"\<Kernel\>\""}], "}"}], 
                 ",", "\[IndentingNewLine]", 
                 RowBox[{"{", 
                  RowBox[{
                  "\"\<Documentation\>\"", ",", "\"\<Documentation\>\""}], 
                  "}"}]}], "\[IndentingNewLine]", "}"}]}]}], 
             "\[IndentingNewLine]", "}"}]}], 
           RowBox[{"(*", " ", "Resource", " ", "*)"}], "\[IndentingNewLine]", 
           "}"}]}], 
         RowBox[{"(*", " ", "Extensions", " ", "*)"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"(*", " ", 
          RowBox[{
           RowBox[{"--", " ", "a"}], " ", "list", " ", "of", " ", "names", 
           " ", "the", " ", "resources", " ", "provided", " ", "by", " ", 
           "the", " ", "paclet", " ", "are", " ", "tagged", " ", 
           RowBox[{"with", ":", " ", 
            RowBox[{"discoverable", " ", "--"}]}]}], " ", "*)"}], 
         "\[IndentingNewLine]", 
         RowBox[{"(*", " ", 
          RowBox[{
           RowBox[{"--", " ", "by"}], " ", "name", " ", "using", " ", "the", 
           " ", "PacletManager`PacletResource", " ", "function", " ", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"custom", " ", "field"}], ")"}], " ", "--"}]}], " ", 
          "*)"}], "\[IndentingNewLine]", 
         RowBox[{"\"\<Assets\>\"", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
           "\"\<Icon\>\"", ",", "\"\<IconBig\>\"", ",", 
            "\"\<DirectoryStructure\>\"", ",", "\"\<Kernel\>\"", ",", 
            "\"\<Documentation\>\""}], "}"}]}]}], "\[IndentingNewLine]", 
        "\[RightAssociation]"}], "]"}], 
      RowBox[{"(*", " ", "PacletObject", " ", "*)"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Or", "[", 
        RowBox[{
         RowBox[{"Not", "[", 
          RowBox[{"FileExistsQ", "[", "p", "]"}], "]"}], ",", " ", 
         RowBox[{"DeleteFile", "[", "p", "]"}]}], "]"}], ";", " ", 
       RowBox[{"CreateFile", "[", "p", "]"}]}]}], "\[IndentingNewLine]", 
     "]"}]}], 
   RowBox[{"(*", " ", "Put", " ", "*)"}], "\[IndentingNewLine]", "]"}], 
  RowBox[{"(*", " ", "Module", " ", "*)"}], "\[IndentingNewLine]"}]], "Input",\
ExpressionUUID->"7a3e5340-522d-4930-959c-e94817f9dea7"]
}, Open  ]],

Cell[CellGroupData[{

Cell["New vs. old syntax comparison", "Section",ExpressionUUID->"cbd2c73a-e5a5-4816-abd1-e9acad0150b8"],

Cell[CellGroupData[{

Cell["12.1+", "Subsection",ExpressionUUID->"bc395be1-92aa-4cf6-857d-f5a1f604b568"],

Cell["\<\
PacletObject[
  <|
    \"Name\" -> \"ModelPaclet\",
    \"Version\" -> \"1.0\",
    \"WolframVersion\" -> \"12.1\",
    \"Icon\" -> \"Resources/Icons/Icon.png\",
    \"Extensions\" -> {
      {\"Kernel\",
       \"Root\" -> \"Kernel\", \"Context\" -> {\"ModelPaclet`\"}
      }
    }
  |>
]\
\>", "Program",ExpressionUUID->"1de2a0cb-feb7-414a-b40e-9226fa765322"]
}, Open  ]],

Cell[CellGroupData[{

Cell["12.1\[Minus]", "Subsection",ExpressionUUID->"ecbf34a6-60f9-40bf-adcb-23ef6e7b76d5"],

Cell["\<\
Paclet[
  Name -> \"ModelPaclet\",
  Version -> \"1.0\",
  MathematicaVersion -> \"11.3+\",
  WolframVersion -> \"11.3+\",
  Thumbnail -> \"Logo.png\",
  Extensions -> {
    {\"Kernel\",
     Root -> \".\", Context -> \"ModelPaclet`\"
    }
  }
]\
\>", "Program",ExpressionUUID->"7f7c1bc0-ecdf-4ada-b2c4-d0f666a739bc"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowToolbars->"EditBar",
WindowSize->{1140, 1022},
WindowMargins->{{1, Automatic}, {Automatic, 0}},
TrackCellChangeTimes->False,
FrontEndVersion->"12.1 for Microsoft Windows (64-bit) (June 9, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"b671dda1-89e1-413b-8074-bc0304b3d54f"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 83, 0, 96, "Title",ExpressionUUID->"1e64afb1-1dc4-425a-b033-6e7a0f8f07ac"],
Cell[CellGroupData[{
Cell[688, 26, 160, 3, 31, "Item",ExpressionUUID->"2e243ab8-42c4-472d-a4ea-5f5a2de90c28"],
Cell[851, 31, 574, 15, 31, "Item",ExpressionUUID->"42c71cee-34b3-4784-930b-4b2dca52bed6"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1462, 51, 119, 0, 67, "Section",ExpressionUUID->"97ae411f-e03e-4906-8035-27821ff9ce1c"],
Cell[1584, 53, 16779, 374, 1640, "Input",ExpressionUUID->"7a3e5340-522d-4930-959c-e94817f9dea7"]
}, Open  ]],
Cell[CellGroupData[{
Cell[18400, 432, 103, 0, 67, "Section",ExpressionUUID->"cbd2c73a-e5a5-4816-abd1-e9acad0150b8"],
Cell[CellGroupData[{
Cell[18528, 436, 82, 0, 53, "Subsection",ExpressionUUID->"bc395be1-92aa-4cf6-857d-f5a1f604b568"],
Cell[18613, 438, 372, 14, 228, "Program",ExpressionUUID->"1de2a0cb-feb7-414a-b40e-9226fa765322"]
}, Open  ]],
Cell[CellGroupData[{
Cell[19022, 457, 89, 0, 53, "Subsection",ExpressionUUID->"ecbf34a6-60f9-40bf-adcb-23ef6e7b76d5"],
Cell[19114, 459, 328, 13, 213, "Program",ExpressionUUID->"7f7c1bc0-ecdf-4ada-b2c4-d0f666a739bc"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

